/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockCraftingTable;
import lotr.common.inventory.LOTRContainerCraftingTable;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemMountArmor;
import lotr.common.item.LOTRItemThrowingAxe;
import lotr.common.item.LOTRMaterial;
import lotr.common.recipe.LOTRRecipePoisonWeapon;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.tileentity.LOTRTileEntityForgeBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRTileEntityUnsmeltery
extends LOTRTileEntityForgeBase {
    public static Random unsmeltingRand = new Random();
    public static Map<Pair<Item, Integer>, Integer> unsmeltableCraftingCounts = new HashMap<Pair<Item, Integer>, Integer>();
    public float prevRocking;
    public float rocking;
    public float prevRockingPhase;
    public float rockingPhase = unsmeltingRand.nextFloat() * (float)Math.PI * 2.0f;
    public boolean prevServerActive;
    public boolean serverActive;
    public boolean clientActive;

    @Override
    public int getForgeInvSize() {
        return 3;
    }

    @Override
    public void setupForgeSlots() {
        this.inputSlots = new int[]{0};
        this.fuelSlot = 1;
        this.outputSlots = new int[]{2};
    }

    @Override
    protected boolean canMachineInsertInput(ItemStack itemstack) {
        return itemstack != null && this.getLargestUnsmeltingResult(itemstack) != null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.prevServerActive = this.serverActive;
            this.serverActive = this.isSmelting();
            if (this.serverActive != this.prevServerActive) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.prevRocking = this.rocking;
            this.prevRockingPhase = this.rockingPhase;
            this.rockingPhase += 0.1f;
            this.rocking = this.clientActive ? (this.rocking += 0.05f) : (this.rocking -= 0.01f);
            this.rocking = MathHelper.func_76131_a((float)this.rocking, (float)0.0f, (float)1.0f);
        }
    }

    public float getRockingAmount(float tick) {
        float mag = this.prevRocking + (this.rocking - this.prevRocking) * tick;
        float phase = this.prevRockingPhase + (this.rockingPhase - this.prevRockingPhase) * tick;
        return mag * MathHelper.func_76126_a((float)phase);
    }

    @Override
    public int getSmeltingDuration() {
        return 400;
    }

    @Override
    protected boolean canDoSmelting() {
        ItemStack input = this.inventory[this.inputSlots[0]];
        if (input == null) {
            return false;
        }
        ItemStack result = this.getLargestUnsmeltingResult(input);
        if (result == null) {
            return false;
        }
        ItemStack output = this.inventory[this.outputSlots[0]];
        if (output == null) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int resultSize = output.field_77994_a + result.field_77994_a;
        return resultSize <= this.func_70297_j_() && resultSize <= result.func_77976_d();
    }

    @Override
    protected void doSmelt() {
        if (this.canDoSmelting()) {
            ItemStack input = this.inventory[this.inputSlots[0]];
            ItemStack result = this.getRandomUnsmeltingResult(input);
            if (result != null) {
                if (this.inventory[this.outputSlots[0]] == null) {
                    this.inventory[this.outputSlots[0]] = result.func_77946_l();
                } else if (this.inventory[this.outputSlots[0]].func_77969_a(result)) {
                    this.inventory[this.outputSlots[0]].field_77994_a += result.field_77994_a;
                }
            }
            --this.inventory[this.inputSlots[0]].field_77994_a;
            if (this.inventory[this.inputSlots[0]].field_77994_a <= 0) {
                this.inventory[this.inputSlots[0]] = null;
            }
        }
    }

    @Override
    public String getForgeName() {
        return StatCollector.func_74838_a((String)"container.lotr.unsmeltery");
    }

    public boolean canBeUnsmelted(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        ItemStack material = LOTRTileEntityUnsmeltery.getEquipmentMaterial(itemstack);
        if (material != null) {
            if (TileEntityFurnace.func_145952_a((ItemStack)material) != 0) {
                return false;
            }
            if (itemstack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)itemstack.func_77973_b()).func_149688_o().func_76217_h()) {
                return false;
            }
            return this.determineResourcesUsed(itemstack, material) > 0;
        }
        return false;
    }

    public ItemStack getLargestUnsmeltingResult(ItemStack itemstack) {
        if (itemstack == null || !this.canBeUnsmelted(itemstack)) {
            return null;
        }
        ItemStack material = LOTRTileEntityUnsmeltery.getEquipmentMaterial(itemstack);
        if (material == null) {
            System.out.println("Material is null for item: " + itemstack);
            return null;
        }
        int items = this.determineResourcesUsed(itemstack, material);
        int meta = material.func_77960_j();
        if (meta == Short.MAX_VALUE) {
            meta = 0;
        }
        return new ItemStack(material.func_77973_b(), items, meta);
    }

    public ItemStack getRandomUnsmeltingResult(ItemStack itemstack) {
        int items_int;
        ItemStack result = this.getLargestUnsmeltingResult(itemstack);
        if (result == null) {
            return null;
        }
        float items = result.field_77994_a;
        items *= 0.8f;
        if (itemstack.func_77984_f()) {
            items *= (float)(itemstack.func_77958_k() - itemstack.func_77960_j()) / (float)itemstack.func_77958_k();
        }
        if ((items_int = Math.round(items *= MathHelper.func_151240_a((Random)unsmeltingRand, (float)0.7f, (float)1.0f))) <= 0) {
            return null;
        }
        return new ItemStack(result.func_77973_b(), items_int, result.func_77960_j());
    }

    public static ItemStack getEquipmentMaterial(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        Item item = itemstack.func_77973_b();
        ItemStack material = null;
        if (item instanceof ItemTool) {
            material = ((ItemTool)item).func_150913_i().getRepairItemStack();
        } else if (item instanceof ItemSword) {
            material = LOTRMaterial.getToolMaterialByName(((ItemSword)item).func_150932_j()).getRepairItemStack();
        } else if (item instanceof LOTRItemCrossbow) {
            material = ((LOTRItemCrossbow)item).getCrossbowMaterial().getRepairItemStack();
        } else if (item instanceof LOTRItemThrowingAxe) {
            material = ((LOTRItemThrowingAxe)item).getAxeMaterial().getRepairItemStack();
        } else if (item instanceof ItemArmor) {
            material = new ItemStack(((ItemArmor)item).func_82812_d().func_151685_b());
        } else if (item instanceof LOTRItemMountArmor) {
            material = new ItemStack(((LOTRItemMountArmor)item).getMountArmorMaterial().func_151685_b());
        }
        if (material != null) {
            if (item instanceof ItemHoe) {
                return material;
            }
            if (item.func_82789_a(itemstack, material)) {
                return material;
            }
        }
        if (material != null) {
            if (item.func_82789_a(itemstack, material)) {
                return material;
            }
        } else {
            if (item instanceof ItemHoe) {
                return LOTRMaterial.getToolMaterialByName(((ItemHoe)item).func_77842_f()).getRepairItemStack();
            }
            if (item == Items.field_151133_ar) {
                return new ItemStack(Items.field_151042_j);
            }
            if (item == LOTRMod.silverRing) {
                return new ItemStack(LOTRMod.silverNugget);
            }
            if (item == LOTRMod.goldRing) {
                return new ItemStack(Items.field_151074_bl);
            }
            if (item == LOTRMod.mithrilRing) {
                return new ItemStack(LOTRMod.mithrilNugget);
            }
            if (item == LOTRMod.gobletGold) {
                return new ItemStack(Items.field_151043_k);
            }
            if (item == LOTRMod.gobletMithril) {
                return new ItemStack(LOTRMod.mithril);
            }
            if (item == LOTRMod.gobletSilver) {
                return new ItemStack(LOTRMod.silver);
            }
            if (item == LOTRMod.gobletCopper) {
                return new ItemStack(LOTRMod.bronze);
            }
        }
        return null;
    }

    public int determineResourcesUsed(ItemStack itemstack, ItemStack material) {
        return this.determineResourcesUsed(itemstack, material, null);
    }

    public int determineResourcesUsed(ItemStack itemstack, ItemStack material, List<IRecipe> recursiveCheckedRecipes) {
        if (itemstack == null) {
            return 0;
        }
        Pair key = Pair.of((Object)itemstack.func_77973_b(), (Object)itemstack.func_77960_j());
        if (unsmeltableCraftingCounts.containsKey(key)) {
            return unsmeltableCraftingCounts.get(key);
        }
        int count = 0;
        ArrayList<List<IRecipe>> allRecipeLists = new ArrayList<List<IRecipe>>();
        allRecipeLists.add(CraftingManager.func_77594_a().func_77592_b());
        EntityPlayer player = this.getProxyPlayer();
        for (LOTRBlockCraftingTable lOTRBlockCraftingTable : LOTRBlockCraftingTable.allCraftingTables) {
            Object container = LOTRMod.proxy.getServerGuiElement(lOTRBlockCraftingTable.tableGUIID, player, this.field_145850_b, 0, 0, 0);
            if (!(container instanceof LOTRContainerCraftingTable)) continue;
            LOTRContainerCraftingTable containerTable = (LOTRContainerCraftingTable)((Object)container);
            allRecipeLists.add(containerTable.recipeList);
        }
        allRecipeLists.add(LOTRRecipes.uncraftableUnsmeltingRecipes);
        if (recursiveCheckedRecipes == null) {
            recursiveCheckedRecipes = new ArrayList<IRecipe>();
        }
        block1: for (List list : allRecipeLists) {
            for (Object recipesObj : list) {
                ShapelessRecipes shapeless;
                int i;
                Object ingredients;
                ShapedRecipes shaped;
                ItemStack result;
                IRecipe irecipe = (IRecipe)recipesObj;
                if (recursiveCheckedRecipes.contains(irecipe) || (result = irecipe.func_77571_b()) == null || result.func_77973_b() != itemstack.func_77973_b() || !itemstack.func_77984_f() && result.func_77960_j() != itemstack.func_77960_j()) continue;
                recursiveCheckedRecipes.add(irecipe);
                if (irecipe instanceof ShapedRecipes) {
                    shaped = (ShapedRecipes)irecipe;
                    ingredients = shaped.field_77574_d;
                    i = this.countMatchingIngredients(material, Arrays.asList(ingredients), recursiveCheckedRecipes);
                    if ((i /= result.field_77994_a) > 0) {
                        count = i;
                        break block1;
                    }
                }
                if (irecipe instanceof ShapelessRecipes) {
                    shapeless = (ShapelessRecipes)irecipe;
                    ingredients = shapeless.field_77579_b;
                    i = this.countMatchingIngredients(material, (List)ingredients, recursiveCheckedRecipes);
                    if ((i /= result.field_77994_a) > 0) {
                        count = i;
                        break block1;
                    }
                }
                if (irecipe instanceof ShapedOreRecipe) {
                    shaped = (ShapedOreRecipe)irecipe;
                    ingredients = shaped.getInput();
                    i = this.countMatchingIngredients(material, Arrays.asList(ingredients), recursiveCheckedRecipes);
                    if ((i /= result.field_77994_a) > 0) {
                        count = i;
                        break block1;
                    }
                }
                if (irecipe instanceof ShapelessOreRecipe) {
                    shapeless = (ShapelessOreRecipe)irecipe;
                    ingredients = shapeless.getInput();
                    i = this.countMatchingIngredients(material, (List)ingredients, recursiveCheckedRecipes);
                    if ((i /= result.field_77994_a) > 0) {
                        count = i;
                        break block1;
                    }
                }
                if (!(irecipe instanceof LOTRRecipePoisonWeapon)) continue;
                LOTRRecipePoisonWeapon poison = (LOTRRecipePoisonWeapon)irecipe;
                ingredients = new Object[]{poison.getInputItem()};
                i = this.countMatchingIngredients(material, Arrays.asList(ingredients), recursiveCheckedRecipes);
                if ((i /= result.field_77994_a) <= 0) continue;
                count = i;
                break block1;
            }
        }
        unsmeltableCraftingCounts.put((Pair<Item, Integer>)key, count);
        return count;
    }

    public EntityPlayer getProxyPlayer() {
        if (!this.field_145850_b.field_72995_K) {
            return FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(null, "LOTRUnsmeltery"));
        }
        return LOTRMod.proxy.getClientPlayer();
    }

    public int countMatchingIngredients(ItemStack material, List ingredientList, List<IRecipe> recursiveCheckedRecipes) {
        int i = 0;
        for (Object obj : ingredientList) {
            if (obj instanceof ItemStack) {
                ItemStack ingredient = (ItemStack)obj;
                if (OreDictionary.itemMatches((ItemStack)material, (ItemStack)ingredient, (boolean)false)) {
                    ++i;
                    continue;
                }
                int sub = this.determineResourcesUsed(ingredient, material, recursiveCheckedRecipes);
                if (sub <= 0) continue;
                i += sub;
                continue;
            }
            if (!(obj instanceof List)) continue;
            List oreIngredients = (List)obj;
            boolean matched = false;
            for (ItemStack ingredient : oreIngredients) {
                if (!OreDictionary.itemMatches((ItemStack)material, (ItemStack)ingredient, (boolean)false)) continue;
                matched = true;
                break;
            }
            if (matched) {
                ++i;
                continue;
            }
            for (ItemStack ingredient : oreIngredients) {
                int sub = this.determineResourcesUsed(ingredient, material, recursiveCheckedRecipes);
                if (sub <= 0) continue;
                i += sub;
            }
        }
        return i;
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74757_a("Active", this.serverActive);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, data);
    }

    @Override
    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound data = packet.func_148857_g();
        this.clientActive = data.func_74767_n("Active");
    }
}

